unit CdsBrowserMain;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, System.Globalization, System.Resources;

type
  TMainForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    components: System.ComponentModel.IContainer;
    StatusBar: System.Windows.Forms.StatusBar;
    MainMenu: System.Windows.Forms.MainMenu;
    MenuItemFile: System.Windows.Forms.MenuItem;
    MenuItemFileOpen: System.Windows.Forms.MenuItem;
    MenuItem3: System.Windows.Forms.MenuItem;
    MenuItemFileExit: System.Windows.Forms.MenuItem;
    OpenFileDialog: System.Windows.Forms.OpenFileDialog;
    DataGrid: System.Windows.Forms.DataGrid;
    DataSet1: System.Data.DataSet;
    StatusBarPanel1: System.Windows.Forms.StatusBarPanel;
    MenuItemView: System.Windows.Forms.MenuItem;
    MenuItemViewExpand: System.Windows.Forms.MenuItem;
    MenuItemViewCollapse: System.Windows.Forms.MenuItem;
    ToolBar: System.Windows.Forms.ToolBar;
    ToolBarButtonOpen: System.Windows.Forms.ToolBarButton;
    ImageList: System.Windows.Forms.ImageList;
    ToolBarButton1: System.Windows.Forms.ToolBarButton;
    ToolBarButtonExpand: System.Windows.Forms.ToolBarButton;
    ToolBarButtonCollapse: System.Windows.Forms.ToolBarButton;
    PanelPreview: System.Windows.Forms.Panel;
    Splitter1: System.Windows.Forms.Splitter;
    Panel1Grid: System.Windows.Forms.Panel;
    MenuItem1: System.Windows.Forms.MenuItem;
    MenuItemViewDetail: System.Windows.Forms.MenuItem;
    ToolBarButton2: System.Windows.Forms.ToolBarButton;
    ToolBarButtonDetail: System.Windows.Forms.ToolBarButton;
    TextBoxValue: System.Windows.Forms.TextBox;
    PictureBoxValue: System.Windows.Forms.PictureBox;
    MenuItemHelp: System.Windows.Forms.MenuItem;
    MenuItemHelpAbout: System.Windows.Forms.MenuItem;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure MenuItemOpen_Click(sender: System.Object; e: System.EventArgs);
    procedure MenuItem4_Click(sender: System.Object; e: System.EventArgs);
    procedure MenuItemViewExpand_Click(sender: System.Object; e: System.EventArgs);
    procedure MenuItemViewCollapse_Click(sender: System.Object; e: System.EventArgs);
    procedure ToolBar_ButtonClick(sender: System.Object; e: System.Windows.Forms.ToolBarButtonClickEventArgs);
    procedure TMainForm_Load(sender: System.Object; e: System.EventArgs);
    procedure MenuItemViewDetail_Click(sender: System.Object; e: System.EventArgs);
    procedure DataGrid_CurrentCellChanged(sender: System.Object; e: System.EventArgs);
    procedure MenuItemHelpAbout_Click(sender: System.Object; e: System.EventArgs);
    procedure DataGrid_Navigate(sender: System.Object; ne: System.Windows.Forms.NavigateEventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  public
    constructor Create;
    procedure OpenFile(FileName: string);
    procedure ShowPreview(Visible: Boolean);
    procedure UpdateDetailPane;
    procedure UpdateGui;
  end;

implementation

uses
  System.IO, PetrVones.Utils.DataPacket, AboutBox;

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TMainForm.InitializeComponent;
type
  TSystem_Windows_Forms_StatusBarPanelArray = array of System.Windows.Forms.StatusBarPanel;
  TSystem_Windows_Forms_MenuItemArray = array of System.Windows.Forms.MenuItem;
  TSystem_Windows_Forms_ToolBarButtonArray = array of System.Windows.Forms.ToolBarButton;
var
  resources: System.Resources.ResourceManager;
begin
  Self.components := System.ComponentModel.Container.Create;
  resources := System.Resources.ResourceManager.Create(TypeOf(TMainForm));
  Self.StatusBar := System.Windows.Forms.StatusBar.Create;
  Self.StatusBarPanel1 := System.Windows.Forms.StatusBarPanel.Create;
  Self.MainMenu := System.Windows.Forms.MainMenu.Create;
  Self.MenuItemFile := System.Windows.Forms.MenuItem.Create;
  Self.MenuItemFileOpen := System.Windows.Forms.MenuItem.Create;
  Self.MenuItem3 := System.Windows.Forms.MenuItem.Create;
  Self.MenuItemFileExit := System.Windows.Forms.MenuItem.Create;
  Self.MenuItemView := System.Windows.Forms.MenuItem.Create;
  Self.MenuItemViewExpand := System.Windows.Forms.MenuItem.Create;
  Self.MenuItemViewCollapse := System.Windows.Forms.MenuItem.Create;
  Self.MenuItem1 := System.Windows.Forms.MenuItem.Create;
  Self.MenuItemViewDetail := System.Windows.Forms.MenuItem.Create;
  Self.MenuItemHelp := System.Windows.Forms.MenuItem.Create;
  Self.MenuItemHelpAbout := System.Windows.Forms.MenuItem.Create;
  Self.OpenFileDialog := System.Windows.Forms.OpenFileDialog.Create;
  Self.DataSet1 := System.Data.DataSet.Create;
  Self.ToolBar := System.Windows.Forms.ToolBar.Create;
  Self.ToolBarButtonOpen := System.Windows.Forms.ToolBarButton.Create;
  Self.ToolBarButton1 := System.Windows.Forms.ToolBarButton.Create;
  Self.ToolBarButtonExpand := System.Windows.Forms.ToolBarButton.Create;
  Self.ToolBarButtonCollapse := System.Windows.Forms.ToolBarButton.Create;
  Self.ToolBarButton2 := System.Windows.Forms.ToolBarButton.Create;
  Self.ToolBarButtonDetail := System.Windows.Forms.ToolBarButton.Create;
  Self.ImageList := System.Windows.Forms.ImageList.Create(Self.components);
  Self.PanelPreview := System.Windows.Forms.Panel.Create;
  Self.PictureBoxValue := System.Windows.Forms.PictureBox.Create;
  Self.TextBoxValue := System.Windows.Forms.TextBox.Create;
  Self.Splitter1 := System.Windows.Forms.Splitter.Create;
  Self.Panel1Grid := System.Windows.Forms.Panel.Create;
  Self.DataGrid := System.Windows.Forms.DataGrid.Create;
  (System.ComponentModel.ISupportInitialize(Self.StatusBarPanel1)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.DataSet1)).BeginInit;
  Self.PanelPreview.SuspendLayout;
  Self.Panel1Grid.SuspendLayout;
  (System.ComponentModel.ISupportInitialize(Self.DataGrid)).BeginInit;
  Self.SuspendLayout;
  // 
  // StatusBar
  // 
  Self.StatusBar.Location := System.Drawing.Point.Create(0, 407);
  Self.StatusBar.Name := 'StatusBar';
  Self.StatusBar.Panels.AddRange(TSystem_Windows_Forms_StatusBarPanelArray.Create(Self.StatusBarPanel1));
  Self.StatusBar.ShowPanels := True;
  Self.StatusBar.Size := System.Drawing.Size.Create(496, 19);
  Self.StatusBar.TabIndex := 2;
  // 
  // StatusBarPanel1
  // 
  Self.StatusBarPanel1.AutoSize := System.Windows.Forms.StatusBarPanelAutoSize.Spring;
  Self.StatusBarPanel1.Width := 480;
  // 
  // MainMenu
  // 
  Self.MainMenu.MenuItems.AddRange(TSystem_Windows_Forms_MenuItemArray.Create(Self.MenuItemFile, Self.MenuItemView, Self.MenuItemHelp));
  // 
  // MenuItemFile
  // 
  Self.MenuItemFile.Index := 0;
  Self.MenuItemFile.MenuItems.AddRange(TSystem_Windows_Forms_MenuItemArray.Create(Self.MenuItemFileOpen, Self.MenuItem3, Self.MenuItemFileExit));
  Self.MenuItemFile.Text := '&File';
  // 
  // MenuItemFileOpen
  // 
  Self.MenuItemFileOpen.Index := 0;
  Self.MenuItemFileOpen.Shortcut := System.Windows.Forms.Shortcut.CtrlO;
  Self.MenuItemFileOpen.Text := '&Open';
  Include(Self.MenuItemFileOpen.Click, Self.MenuItemOpen_Click);
  // 
  // MenuItem3
  // 
  Self.MenuItem3.Index := 1;
  Self.MenuItem3.Text := '-';
  // 
  // MenuItemFileExit
  // 
  Self.MenuItemFileExit.Index := 2;
  Self.MenuItemFileExit.Text := 'E&xit';
  Include(Self.MenuItemFileExit.Click, Self.MenuItem4_Click);
  // 
  // MenuItemView
  // 
  Self.MenuItemView.Index := 1;
  Self.MenuItemView.MenuItems.AddRange(TSystem_Windows_Forms_MenuItemArray.Create(Self.MenuItemViewExpand, Self.MenuItemViewCollapse, Self.MenuItem1, Self.MenuItemViewDetail));
  Self.MenuItemView.Text := '&View';
  // 
  // MenuItemViewExpand
  // 
  Self.MenuItemViewExpand.Index := 0;
  Self.MenuItemViewExpand.Shortcut := System.Windows.Forms.Shortcut.CtrlE;
  Self.MenuItemViewExpand.Text := '&Expand rows';
  Include(Self.MenuItemViewExpand.Click, Self.MenuItemViewExpand_Click);
  // 
  // MenuItemViewCollapse
  // 
  Self.MenuItemViewCollapse.Index := 1;
  Self.MenuItemViewCollapse.Shortcut := System.Windows.Forms.Shortcut.CtrlC;
  Self.MenuItemViewCollapse.Text := '&Collapse rows';
  Include(Self.MenuItemViewCollapse.Click, Self.MenuItemViewCollapse_Click);
  // 
  // MenuItem1
  // 
  Self.MenuItem1.Index := 2;
  Self.MenuItem1.Text := '-';
  // 
  // MenuItemViewDetail
  // 
  Self.MenuItemViewDetail.Index := 3;
  Self.MenuItemViewDetail.Shortcut := System.Windows.Forms.Shortcut.CtrlD;
  Self.MenuItemViewDetail.Text := '&Detail pane';
  Include(Self.MenuItemViewDetail.Click, Self.MenuItemViewDetail_Click);
  // 
  // MenuItemHelp
  // 
  Self.MenuItemHelp.Index := 2;
  Self.MenuItemHelp.MenuItems.AddRange(TSystem_Windows_Forms_MenuItemArray.Create(Self.MenuItemHelpAbout));
  Self.MenuItemHelp.Text := '&Help';
  // 
  // MenuItemHelpAbout
  // 
  Self.MenuItemHelpAbout.Index := 0;
  Self.MenuItemHelpAbout.Text := '&About';
  Include(Self.MenuItemHelpAbout.Click, Self.MenuItemHelpAbout_Click);
  // 
  // OpenFileDialog
  // 
  Self.OpenFileDialog.Filter := 'ClientDataSet XML files (*.xml)|*.xml';
  Self.OpenFileDialog.Title := 'Open CDS file';
  // 
  // DataSet1
  // 
  Self.DataSet1.DataSetName := 'NewDataSet';
  Self.DataSet1.Locale := System.Globalization.CultureInfo.Create('cs-CZ');
  // 
  // ToolBar
  // 
  Self.ToolBar.Appearance := System.Windows.Forms.ToolBarAppearance.Flat;
  Self.ToolBar.Buttons.AddRange(TSystem_Windows_Forms_ToolBarButtonArray.Create(Self.ToolBarButtonOpen, Self.ToolBarButton1, Self.ToolBarButtonExpand, Self.ToolBarButtonCollapse, Self.ToolBarButton2, Self.ToolBarButtonDetail));
  Self.ToolBar.DropDownArrows := True;
  Self.ToolBar.ImageList := Self.ImageList;
  Self.ToolBar.Location := System.Drawing.Point.Create(0, 0);
  Self.ToolBar.Name := 'ToolBar';
  Self.ToolBar.ShowToolTips := True;
  Self.ToolBar.Size := System.Drawing.Size.Create(496, 28);
  Self.ToolBar.TabIndex := 0;
  Self.ToolBar.Wrappable := False;
  Include(Self.ToolBar.ButtonClick, Self.ToolBar_ButtonClick);
  // 
  // ToolBarButtonOpen
  // 
  Self.ToolBarButtonOpen.ImageIndex := 0;
  Self.ToolBarButtonOpen.ToolTipText := 'Open';
  // 
  // ToolBarButton1
  // 
  Self.ToolBarButton1.Style := System.Windows.Forms.ToolBarButtonStyle.Separator;
  // 
  // ToolBarButtonExpand
  // 
  Self.ToolBarButtonExpand.ImageIndex := 1;
  Self.ToolBarButtonExpand.ToolTipText := 'Expand rows';
  // 
  // ToolBarButtonCollapse
  // 
  Self.ToolBarButtonCollapse.ImageIndex := 2;
  Self.ToolBarButtonCollapse.ToolTipText := 'Collapse rows';
  // 
  // ToolBarButton2
  // 
  Self.ToolBarButton2.Style := System.Windows.Forms.ToolBarButtonStyle.Separator;
  // 
  // ToolBarButtonDetail
  // 
  Self.ToolBarButtonDetail.ImageIndex := 3;
  Self.ToolBarButtonDetail.ToolTipText := 'Show detail pane';
  // 
  // ImageList
  // 
  Self.ImageList.ColorDepth := System.Windows.Forms.ColorDepth.Depth32Bit;
  Self.ImageList.ImageSize := System.Drawing.Size.Create(16, 16);
  Self.ImageList.ImageStream := (System.Windows.Forms.ImageListStreamer(resources.GetObject('ImageList.ImageStream')));
  Self.ImageList.TransparentColor := System.Drawing.Color.White;
  // 
  // PanelPreview
  // 
  Self.PanelPreview.BorderStyle := System.Windows.Forms.BorderStyle.Fixed3D;
  Self.PanelPreview.Controls.Add(Self.PictureBoxValue);
  Self.PanelPreview.Controls.Add(Self.TextBoxValue);
  Self.PanelPreview.Dock := System.Windows.Forms.DockStyle.Bottom;
  Self.PanelPreview.Location := System.Drawing.Point.Create(0, 335);
  Self.PanelPreview.Name := 'PanelPreview';
  Self.PanelPreview.Size := System.Drawing.Size.Create(496, 72);
  Self.PanelPreview.TabIndex := 3;
  // 
  // PictureBoxValue
  // 
  Self.PictureBoxValue.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.PictureBoxValue.Location := System.Drawing.Point.Create(0, 0);
  Self.PictureBoxValue.Name := 'PictureBoxValue';
  Self.PictureBoxValue.Size := System.Drawing.Size.Create(492, 68);
  Self.PictureBoxValue.SizeMode := System.Windows.Forms.PictureBoxSizeMode.CenterImage;
  Self.PictureBoxValue.TabIndex := 1;
  Self.PictureBoxValue.TabStop := False;
  // 
  // TextBoxValue
  // 
  Self.TextBoxValue.BorderStyle := System.Windows.Forms.BorderStyle.None;
  Self.TextBoxValue.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.TextBoxValue.Location := System.Drawing.Point.Create(0, 0);
  Self.TextBoxValue.Multiline := True;
  Self.TextBoxValue.Name := 'TextBoxValue';
  Self.TextBoxValue.ReadOnly := True;
  Self.TextBoxValue.ScrollBars := System.Windows.Forms.ScrollBars.Both;
  Self.TextBoxValue.Size := System.Drawing.Size.Create(492, 68);
  Self.TextBoxValue.TabIndex := 0;
  Self.TextBoxValue.Text := 'Value';
  // 
  // Splitter1
  // 
  Self.Splitter1.Dock := System.Windows.Forms.DockStyle.Bottom;
  Self.Splitter1.Location := System.Drawing.Point.Create(0, 332);
  Self.Splitter1.Name := 'Splitter1';
  Self.Splitter1.Size := System.Drawing.Size.Create(496, 3);
  Self.Splitter1.TabIndex := 4;
  Self.Splitter1.TabStop := False;
  // 
  // Panel1Grid
  // 
  Self.Panel1Grid.Controls.Add(Self.DataGrid);
  Self.Panel1Grid.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.Panel1Grid.Location := System.Drawing.Point.Create(0, 28);
  Self.Panel1Grid.Name := 'Panel1Grid';
  Self.Panel1Grid.Size := System.Drawing.Size.Create(496, 304);
  Self.Panel1Grid.TabIndex := 5;
  // 
  // DataGrid
  // 
  Self.DataGrid.DataMember := '';
  Self.DataGrid.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.DataGrid.HeaderForeColor := System.Drawing.SystemColors.ControlText;
  Self.DataGrid.Location := System.Drawing.Point.Create(0, 0);
  Self.DataGrid.Name := 'DataGrid';
  Self.DataGrid.ReadOnly := True;
  Self.DataGrid.Size := System.Drawing.Size.Create(496, 304);
  Self.DataGrid.TabIndex := 2;
  Include(Self.DataGrid.Navigate, Self.DataGrid_Navigate);
  Include(Self.DataGrid.CurrentCellChanged, Self.DataGrid_CurrentCellChanged);
  // 
  // TMainForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(496, 426);
  Self.Controls.Add(Self.Panel1Grid);
  Self.Controls.Add(Self.Splitter1);
  Self.Controls.Add(Self.PanelPreview);
  Self.Controls.Add(Self.ToolBar);
  Self.Controls.Add(Self.StatusBar);
  Self.Menu := Self.MainMenu;
  Self.MinimumSize := System.Drawing.Size.Create(300, 250);
  Self.Name := 'TMainForm';
  Self.Text := 'ClientDataSet xml files browser';
  Include(Self.Load, Self.TMainForm_Load);
  (System.ComponentModel.ISupportInitialize(Self.StatusBarPanel1)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.DataSet1)).EndInit;
  Self.PanelPreview.ResumeLayout(False);
  Self.Panel1Grid.ResumeLayout(False);
  (System.ComponentModel.ISupportInitialize(Self.DataGrid)).EndInit;
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TMainForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TMainForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TMainForm.OpenFile(FileName: string);
var
  Reader: StreamReader;
begin
  StatusBarPanel1.Text := '';
  DataSet1.Reset;
  UpdateGui;
  UpdateDetailPane;
  Update;
  DataGrid.CaptionText := '';
  DataGrid.DataSource := nil;
  Reader := StreamReader.Create(FileName);
  try
    Cursor.Current := Cursors.WaitCursor;
    FillDataSet(DataSet1, Reader);
    DataGrid.SetDataBinding(DataSet1.Copy, 'ROW'); // workaround for columns caching problem
    DataGrid.CaptionText := Path.GetFileName(FileName);
    StatusBarPanel1.Text := FileName;
    UpdateGui;
    UpdateDetailPane;
  finally
    Cursor.Current := Cursors.Default;
    Reader.Close;
  end;
end;

procedure TMainForm.UpdateGui;
begin
  MenuItemViewExpand.Enabled := DataSet1.Tables.Count > 1;
  MenuItemViewCollapse.Enabled := DataSet1.Tables.Count > 1;
  ToolBarButtonExpand.Enabled := DataSet1.Tables.Count > 1;
  ToolBarButtonCollapse.Enabled := DataSet1.Tables.Count > 1;
  ToolBarButtonDetail.Pushed := MenuItemViewDetail.Checked;
end;

procedure TMainForm.DataGrid_Navigate(sender: System.Object; ne: System.Windows.Forms.NavigateEventArgs);
begin
  UpdateDetailPane;
end;

procedure TMainForm.MenuItemHelpAbout_Click(sender: System.Object; e: System.EventArgs);
begin
  TAboutBox.ShowAboutBox;
end;

procedure TMainForm.DataGrid_CurrentCellChanged(sender: System.Object; e: System.EventArgs);
begin
  UpdateDetailPane;
end;

procedure TMainForm.MenuItemViewDetail_Click(sender: System.Object; e: System.EventArgs);
begin
  ShowPreview(not MenuItemViewDetail.Checked);
end;

procedure TMainForm.TMainForm_Load(sender: System.Object; e: System.EventArgs);
begin
  ShowPreview(False);
  UpdateGui;
end;

procedure TMainForm.ToolBar_ButtonClick(sender: System.Object; e: System.Windows.Forms.ToolBarButtonClickEventArgs);
begin
  if e.Button = ToolBarButtonOpen then
    MenuItemOpen_Click(sender, e)
  else
  if e.Button = ToolBarButtonCollapse then
    MenuItemViewCollapse_Click(sender, e)
  else
  if e.Button = ToolBarButtonExpand then
    MenuItemViewExpand_Click(sender, e)
  else  
  if e.Button = ToolBarButtonDetail then
    MenuItemViewDetail_Click(sender, e);
end;

procedure TMainForm.MenuItemViewCollapse_Click(sender: System.Object; e: System.EventArgs);
begin
  DataGrid.Collapse(-1);
end;

procedure TMainForm.MenuItemViewExpand_Click(sender: System.Object; e: System.EventArgs);
begin
  DataGrid.Expand(-1);
end;

procedure TMainForm.MenuItemOpen_Click(sender: System.Object; e: System.EventArgs);
begin
  OpenFileDialog.FileName := '';
  if OpenFileDialog.ShowDialog = System.Windows.Forms.DialogResult.OK then
    OpenFile(OpenFileDialog.FileName);
end;

procedure TMainForm.MenuItem4_Click(sender: System.Object; e: System.EventArgs);
begin
  Application.Exit;
end;

procedure TMainForm.ShowPreview(Visible: Boolean);
begin
  MenuItemViewDetail.Checked := Visible;
  PanelPreview.Visible := Visible;
  Splitter1.Visible := Visible;
  UpdateGui;
  if Visible then
    UpdateDetailPane;
end;

procedure TMainForm.UpdateDetailPane;
var
  R, C: Integer;
  Value: &Object;
  TextValue: Boolean;
  Picture: Image;

  procedure TryReadPicture;
  var
    PictureData: TBytes;
    MemStream: MemoryStream;
  begin
    PictureData := TBytes(Value);
    MemStream := MemoryStream.Create(PictureData);
    try
      Picture := Image.FromStream(MemStream);
      TextValue := False;
    except
      try
        MemStream.SetLength(0);
        MemStream.Write(PictureData, 8, System.Array(PictureData).Length - 8);
        Picture := Image.FromStream(MemStream);
        TextValue := False;
      except
        MemStream.Close;
      end;
    end;
  end;

begin
  if MenuItemViewDetail.Checked and (DataSet1.Tables.Count > 0) then
  begin
    R := DataGrid.CurrentCell.RowNumber;
    C := DataGrid.CurrentCell.ColumnNumber;
    try
      Value := DataGrid[R, C];
    except
      on E: ArgumentException do
        Value := '';
    end;
    Picture := nil;
    TextValue := True;
    if Value.GetType = typeof(TBytes) then
      TryReadPicture;
    if TextValue then
    begin
      TextBoxValue.Text := Value.ToString.Replace(#10, #13#10);
      TextBoxValue.Visible := True;
      PictureBoxValue.Visible := False;
    end
    else
    begin
      PictureBoxValue.Image := Picture;
      TextBoxValue.Visible := False;
      PictureBoxValue.Visible := True;
    end;
  end
  else
  begin
    PictureBoxValue.Visible := False;
    TextBoxValue.Visible := False;
  end;
end;

end.
